# import bpy
# from typing import List
from .common_list_methods import FLUIDLAB_CommonList
from ...addon.naming import FluidLabNaming
from bpy.types import PropertyGroup, UIList, Collection
from ...libs.functions.get_common_vars import get_common_vars
from ...libs.functions.collections import remove_collection_if_is_empty, hide_unhide_collection, remove_collection
from bpy.props import StringProperty, IntProperty, CollectionProperty, BoolProperty, PointerProperty
from .props_list_fluid_forces import FluidForcesList


""" Fluids Forces Groups List """


class FLUIDLAB_UL_draw_fluids_froces_groups(UIList):

    def draw_item(self, context, layout, data, item, icon, active_data, active_propname, index):
        
        if not item.id_name or not item.group_coll:
            layout.prop(item, "remove", text="Clear", icon='X')
            return
        
        left_sect = layout.row(align=True)

        # left_sect.prop(item, "label_txt", text="", emboss=False)
        left_sect.prop(item.group_coll, "name", text="", emboss=False)

        # Right Section:
        right_sect = left_sect.row(align=True)
        right_sect.alignment = 'RIGHT'
        
        # Visible icon:
        right_sect.prop(item, "visible", text="", icon='HIDE_OFF' if item.visible else 'HIDE_ON', emboss=False)

        # Remove icon:
        rm_button = right_sect.row(align=True)
        rm_button.alert = True
        rm_button.prop(item, "remove", text="", emboss=False, icon='X')


class FluidForcesGroupsListItem(PropertyGroup):
    label_txt: StringProperty(name="Name")
    id_name: StringProperty(name="ID")
    forces: PointerProperty(type=FluidForcesList)
    group_coll: PointerProperty(type=Collection)
        
    def do_remove(self, context):
        
        fluid_forces_groups = get_common_vars(context, get_fluid_forces_groups=True)

        # Eliminamos la collection:
        remove_collection(context, self.group_coll, True)

        # Lo quitamos del listado:
        fluid_forces_groups.remove_item(self.id_name)
        fluid_forces_groups.list_index = fluid_forces_groups.length-1 if not fluid_forces_groups.is_void else 0 
    
        # Elimino FL_Forces si estuviera vacio:
        remove_collection_if_is_empty(context, FluidLabNaming.MAIN_FORCES_COLL)
        
        # Elimino FLuidLab si estuviera vacio:
        remove_collection_if_is_empty(context, FluidLabNaming.FluidLab)

    remove: BoolProperty(
        default=False, 
        update=do_remove
    )

    def visible_update(self, context):
        hide_unhide_collection(context, self.group_coll.name, "hide_viewport", visibility=not self.visible)
    

    visible: BoolProperty(
        default=True, 
        update=visible_update
    )

    # weights_props:
    # POR HACER


class FluidForcesGroupsList(PropertyGroup, FLUIDLAB_CommonList):


    def list_index_update(self, context):
        item = self.active
        if not item:
            return
        pass
    
    list_index: IntProperty(name="Layer List", description="The Layer List", default=-1, update=list_index_update)
    list: CollectionProperty(type=FluidForcesGroupsListItem)


    # Fluid Groups List Methods:
    def add_item(self, item_id:str, label_txt:str, group_coll:Collection) -> FluidForcesGroupsListItem:

        item = self.list.add()
        item.id_name = item_id
        item.label_txt = label_txt
        item.group_coll = group_coll
        
        # seteamos el ultimo elemento como activo:
        self.list_index = self.length-1

        return item